//
//  MCReportRenderCanvas.h
//  Composer
//
//  Created by Alykhan Jetha on 04/06/2005.
//  Copyright 2005 Marketcircle Inc.. All rights reserved.
//

#import <Cocoa/Cocoa.h>

@class MCReportElement;

@interface MCReportRenderCanvas : NSView {
	NSPrintInfo *printInfo;
	float yCursor;
	float xCursor;
	float yCursorMax;  
	int currentPageCount;
	
	NSArray *decorations;
	NSMutableSet *decorationClones;
	NSRect bodyFrame;
	NSRect originalBodyFrame;
	
	int drawsDebugLines;
	
	MCReportElement *lastReportElement; // weak ref
}

- (NSPrintInfo *)printInfo;
- (void)setPrintInfo:(NSPrintInfo *)aPrintInfo;

- (NSArray *)decorations;
- (void)setDecorations:(NSArray *)aDecorations;

- (NSMutableSet *)decorationClones;
- (void)setDecorationClones:(NSMutableSet *)aDecorationClones;
- (void)addDecorationClone:(id)aDecorationClone;
- (void)removeDecorationClone:(id)aDecorationClone;

- (void)setFirstTimeBodyFrame:(NSRect)aFrame;
- (void)setBodyFrame:(NSRect)aFrame;
- (NSRect)bodyFrame;

- (NSRect)originalBodyFrame;
- (void)setOriginalBodyFrame:(NSRect)anOriginalBodyFrame;

// if there is room on the body of the page and there nothing following, then the strip will be stretched to match
- (void)stretchStripElementToMatchBodyIfAppropriate:(MCReportElement *)aStrip;

- (float)remainingHeightOnCurrentPage;

//- (BOOL)needsToAddPageToFitView:(NSView *)aView;
- (void)addPage;
- (void)appendView:(MCReportElement *)aView;

- (int)drawsDebugLines;
- (void)setDrawsDebugLines:(int)val;

- (void)propagateTotalPageCountToAllViews;
- (void)propagateLoadImageFromCacheToAllViews;
- (void)propagateStretchHeightToMatchParentToAllViews;

- (void)removeLastPageIfAppropriate;

@end
